﻿using System;

namespace Microscopic_Traffic_Simulator___Model.SimulationControl
{
    /// <summary>
    /// Represents comparable key containing time and priority.
    /// </summary>
    internal struct SimulationEventGeneratorKey : IComparable
    {
        /// <summary>
        /// Time of the key.
        /// </summary>
        internal TimeSpan Time;

        /// <summary>
        /// Priority of the key.
        /// </summary>
        internal int Priority;

        /// <summary>
        /// Initializes the key.
        /// </summary>
        /// <param name="time">Time of the key.</param>
        /// <param name="priority">Priority of the key.</param>
        internal SimulationEventGeneratorKey(TimeSpan time, int priority)
        {
            Time = time;
            Priority = priority;
        }

        /// <summary>
        /// Compares key with another key. At first the times are compared and in case they are equal priorities are
        /// compared.
        /// </summary>
        /// <param name="obj">Other key.</param>
        /// <returns>Result of the comparison.</returns>
        public int CompareTo(object obj)
        {
            if (!(obj is SimulationEventGeneratorKey))
            {
                throw new ArgumentException();
            }
            
            SimulationEventGeneratorKey other = (SimulationEventGeneratorKey) obj;

            int timeCompareResult = Time.CompareTo(other.Time);
            if (timeCompareResult == 0)
            {
                return Priority.CompareTo(other.Priority);
            }
            else
            {
                return timeCompareResult;
            }
        }
    }
}
